defmodule Outreachtool.RogersController do
  use Outreachtool.Web, :controller
  alias ExAws.S3

  def rogers_bonus(conn, %{"page" => page}) do
    {:ok, urls} = File.read("web/static/assets/rogers_bonus_content.txt")
    {int, _rest} = Integer.parse(page)

    urls = urls |> String.split("\n")
    |> Enum.map(fn(url) ->
      {:ok, s3_signed_url} = ExAws.S3.presigned_url(ExAws.Config.new(:s3, []), :get, "twitch-creative-video-repository",  url)
      {url, s3_signed_url}
    end)
    |> Enum.drop(11)
    |> Enum.slice((int*6+1)..(int*6+6))

    conn
    |> assign(:urls, urls)
    |> render "rogers_bonus.html"
  end
  def rogers_bonus(conn, _params), do: rogers_bonus(conn, %{"page" => "0"})


  def rogers(conn, %{"page" => page}) do
    {:ok, lines} = File.read("web/static/assets/rogers_qc_assets.txt")
    {int, _rest} = Integer.parse(page)

    urls = lines
    |> String.split("\n")
    |> Enum.drop(1)
    |> Enum.map(fn(line) ->
      [season, episode, s3_qc_path] = String.split(line, ",")
      name = String.replace(s3_qc_path, "prod_qc/misterrogers/", "")
      {:ok, s3_signed_url} = ExAws.S3.presigned_url(ExAws.Config.new(:s3, []), :get, "twitch-creative-video-repository",  s3_qc_path)
      {season, episode, name, s3_signed_url}
    end)
    |> Enum.slice((int*6)..(int*6+5))

    conn
    |> assign(:urls, urls)
    |> render "rogers.html"
  end
  def rogers(conn, _params), do: rogers(conn, %{"page" => "0"})

end
