defmodule Outreachtool.InstagramPost do
  use Outreachtool.Web, :model

  schema "instagram_posts" do
    field :instagram_id, :string
    field :username, :string
    field :time, :integer
    field :type, :string
    field :likes, :integer
    field :comments, :integer
    field :text, :string
    field :media, :string

    timestamps()
  end

  @doc """
  Builds a changeset based on the `struct` and `params`.
  """
  def changeset(struct, params \\ %{}) do
    struct
    |> cast(params, [:instagram_id, :username, :time, :type, :likes, :comments, :text, :media, :updated_at])
    |> validate_required([:instagram_id, :username, :time, :type, :likes, :comments, :text, :media])
  end
end
