defmodule Outreachtool.Router do
  use Outreachtool.Web, :router

  pipeline :browser do
    plug :accepts, ["html"]
    plug :fetch_session
    plug :fetch_flash
    plug :put_secure_browser_headers
  end

  pipeline :api do
    plug :accepts, ["json"]
  end

  scope "/", Outreachtool do
    pipe_through :browser # Use the default browser stack

    get "/", PageController, :index
    post "/search", PageController, :search
    post "/profile", PageController, :profile
    get "/rogers_bonus", RogersController, :rogers_bonus
    get "/rogers", RogersController, :rogers
  end

  # Other scopes may use custom stacks.
  # scope "/api", Outreachtool do
  #   pipe_through :api
  # end
end
