package appconfig

import (
	"encoding/json"
	"errors"
	"os"
)

// Configuration configures the app
type Configuration struct {
	Environment       string
	RollbarToken      string
	MissionControlURL string
}

// Config is the global configuration struct
var Config Configuration

// Parse parses the right Config file
func Parse() {
	env := os.Getenv("APP_ENV")
	if env == "" {
		env = "development"
	}

	file, err := os.Open(env + ".json")
	if err != nil {
		panic(errors.New("Config file not found"))
	}
	Config = Configuration{}
	err = json.NewDecoder(file).Decode(&Config)
	if err != nil {
		panic(errors.New("Config file is invalid"))
	}
}
