package util

import "github.com/stvp/rollbar"

// Closable is an interface that we want to close and log
type Closable interface {
	Close() error
}

// CloseAndReport closes then logs to rollbar if it fails
func CloseAndReport(closeable Closable) {
	err := closeable.Close()
	if err != nil {
		rollbar.Error(rollbar.WARN, err)
	}
}
