package main

import (
	"code.justin.tv/creative/streamer/lib/config"
	"code.justin.tv/creative/streamer/server"
	"code.justin.tv/creative/streamer/stream"
	"github.com/aws/aws-sdk-go/service/s3"
	"github.com/stvp/rollbar"
)

var svc *s3.S3

func main() {
	appconfig.Parse()

	configuration := appconfig.Config
	rollbar.Token = configuration.RollbarToken
	rollbar.Environment = configuration.Environment

	go server.Serve()
	stream.Streamer()
}
