package server

import (
	"io"
	"log"
	"net/http"
	"strconv"
	"strings"

	"code.justin.tv/creative/streamer/lib/config"
	"code.justin.tv/creative/streamer/lib/missioncontrol"
	"code.justin.tv/creative/streamer/lib/util"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/credentials"
	"github.com/aws/aws-sdk-go/aws/session"
	"github.com/aws/aws-sdk-go/service/s3"
	"github.com/stvp/rollbar"
)

// Serve is a proxy for ffmpeg to use.
// FFMPEG supports concatenation through the concat protocol
// https://ffmpeg.org/ffmpeg-formats.html#concat
// In order to support the "linked-list" wherein each file list contains one
// media file and a url pointing to the next filelist, we have to use
// "ffconcat version 1" as the header which enable safe mode. Safe mode requires
// all media content be a sibling or a "nephew" of the file list being used to
// concat  in order to support nested  file list calls. Therefore this proxy
// server replaces all of the dashes in the url with slashes allowing the file
// list to be on the top level.
func Serve() {
	svc := s3.New(session.New(&aws.Config{
		Region: aws.String("us-west-2"),
		Credentials: credentials.NewStaticCredentials(
			"AKIAJMB5L4TV3YCZKDYA",
			"zayIrMdYt/yOZzLEjZR2C1qcqMPHFSdHrKTRzgTo",
			"",
		),
	}))

	http.HandleFunc("/", func(w http.ResponseWriter, r *http.Request) {
		if strings.HasPrefix(r.URL.Path, "/twitch-creative-video-repository") {
			bucket := "twitch-creative-video-repository"
			streamSessionVideoIDString := r.URL.Path[2+len(bucket):]
			streamSessionVideoID, err := strconv.Atoi(streamSessionVideoIDString)
			if err != nil {
				rollbar.Error(rollbar.ERR, err)
				return
			}
			ssv := missioncontrol.GetStreamSessionVideo(&streamSessionVideoID)
			key := ssv.Video.S3Path

			params := &s3.GetObjectInput{
				Bucket: aws.String(bucket),
				Key:    aws.String(key),
				Range:  aws.String(r.Header.Get("Range")),
			}
			req, _ := svc.GetObjectRequest(params)

			if err := req.Send(); err != nil {
				rollbar.RequestError(rollbar.ERR, r, err)
				// This error handling code is to ensure ffmpeg's edge case with last byte is ok
				newHeader := r.Header.Get("Range")
				newHeader = newHeader[6 : len(newHeader)-1]
				newHeaderCount, err := strconv.Atoi(newHeader)
				if err != nil {
					rollbar.Error(rollbar.ERR, err)
					return
				}
				newHeaderCount--
				newHeader = "bytes=" + strconv.Itoa(newHeaderCount) + "-"
				params := &s3.GetObjectInput{
					Bucket: aws.String(bucket),
					Key:    aws.String(key),
					Range:  aws.String(newHeader),
				}
				req, _ = svc.GetObjectRequest(params)
				if err := req.Send(); err != nil {
					rollbar.RequestError(rollbar.ERR, r, err)
					return
				}
				// return
			}
			defer util.CloseAndReport(req.HTTPResponse.Body)
			resp := req.HTTPResponse
			for header := range resp.Header {
				w.Header().Set(header, resp.Header.Get(header))
			}
			w.WriteHeader(resp.StatusCode)
			_, _ = io.Copy(w, req.HTTPResponse.Body)
		} else {
			fullURL := appconfig.Config.MissionControlURL + "/" + strings.Replace(r.URL.Path, "-", "/", -1)
			resp, err := http.Get(fullURL)
			if err != nil {
				rollbar.Error(rollbar.ERR, err)
				return
			}
			defer util.CloseAndReport(resp.Body)

			_, _ = io.Copy(w, resp.Body)
		}
	})

	log.Fatal(http.ListenAndServe(":8080", nil))
}
