defmodule Bot do
  require IEx
  use Application

  # See http://elixir-lang.org/docs/stable/elixir/Application.html
  # for more information on OTP Applications
  def start(_type, _args) do
    import Supervisor.Spec, warn: false

    {:ok, client} = ExIrc.start_client!

    # Define workers and child supervisors to be supervised
    children = [
      # Starts a worker by calling: Bot.Worker.start_link(arg1, arg2, arg3)
      # worker(Bot.Worker, [arg1, arg2, arg3]),
      worker(BotConnectionHandler, [client]),
      # here's where we specify the channels to join:
      worker(BotLoginHandler, [client, ["#doonest", "#doon_bot", "#qwertyowlkin"]])
    ]

    # See http://elixir-lang.org/docs/stable/elixir/Supervisor.html
    # for other strategies and supported options
    opts = [strategy: :one_for_one, name: Bot.Supervisor]
    Supervisor.start_link(children, opts)
  end
end

defmodule BotConnectionHandler do
  require IEx
  defmodule State do
    defstruct host: "irc.twitch.tv",
              port: 6667,
              pass: "oauth:g55q3dvlh08rzw3irh87kaw8re7kzp",
              nick: "doon_bot",
              user: "doon_bot",
              name: "doon_bot",
              client: nil
  end

  def start_link(client, state \\ %State{}) do
    GenServer.start_link(__MODULE__, [%{state | client: client}])
  end

  def init([state]) do
    ExIrc.Client.add_handler state.client, self
    ExIrc.Client.connect! state.client, state.host, state.port
    {:ok, state}
  end

  def handle_info({:connected, server, port}, state) do
    debug "Connected to #{server}:#{port}"
    ExIrc.Client.logon state.client, state.pass, state.nick, state.user, state.name
    {:noreply, state}
  end

  def handle_info({:received, text, user, channel}, state) do
    debug "Received Chat Message: #{text} on channel #{channel}"
    IO.inspect state
    process(text, channel, state.client)

    {:noreply, state}
  end

  # Catch-all for messages you don't care about
  # msg = {}
  def handle_info(msg, state) do
    debug "Received unknown messsage:"
    IO.inspect msg
    # {:thing, text, info, channel} = msg
    {:noreply, state}
  end

  def process("Ping", channel, client) do
    ExIrc.Client.msg client, :privmsg, channel, "Pong"
  end
  def process(_, _, _), do: nil

  defp debug(msg) do
    IO.puts IO.ANSI.yellow() <> msg <> IO.ANSI.reset()
  end
end

defmodule BotLoginHandler do
  @moduledoc """
  This is an example event handler that listens for login events and then
  joins the appropriate channels. We actually need this because we can't
  join channels until we've waited for login to complete. We could just
  attempt to sleep until login is complete, but that's just hacky. This
  as an event handler is a far more elegant solution.
  """
  def start_link(client, channels) do
    GenServer.start_link(__MODULE__, [client, channels])
  end

  def init([client, channels]) do
    ExIrc.Client.add_handler client, self
    {:ok, {client, channels}}
  end

  def handle_info(:logged_in, state = {client, channels}) do
    debug "Logged in to server"
    channels |> Enum.map(&ExIrc.Client.join client, &1)
    {:noreply, state}
  end

  # Catch-all for messages you don't care about
  def handle_info(_msg, state) do
    {:noreply, state}
  end

  defp debug(msg) do
    IO.puts IO.ANSI.yellow() <> msg <> IO.ANSI.reset()
  end
end
