# This file is responsible for configuring your application
# and its dependencies with the aid of the Mix.Config module.
#
# This configuration file is loaded before any dependency and
# is restricted to this project.
use Mix.Config

# General application configuration
config :manager,
  ecto_repos: [Manager.Repo]

# Configures the endpoint
config :manager, Manager.Endpoint,
  url: [host: "localhost"],
  secret_key_base: "riTKZx4OmfRq0Lhhy3laZy2agEQY0fLgY7Dib6RK46ZcI4NkeAQCn4o6nr5WEkWB",
  render_errors: [view: Manager.ErrorView, accepts: ~w(html json)],
  pubsub: [name: Manager.PubSub,
           adapter: Phoenix.PubSub.PG2]

# Configures Elixir's Logger
config :logger, :console,
  format: "$time $metadata[$level] $message\n",
  metadata: [:request_id]

# Import environment specific config. This must remain at the bottom
# of this file so it overrides the configuration defined above.
import_config "#{Mix.env}.exs"

config :ex_aws,
  access_key_id: ["AKIAI6MI2ZFGHXANQ6FQ", :instance_role],
  secret_access_key: ["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", :instance_role],
  region: "us-west-2"
