defmodule Manager.VideoTest do
  use Manager.ModelCase

  alias Manager.Video

  @valid_attrs %{channel_id: 42, length: 42, s3_path: "some content", season: "some content", show: "some content", title: "some content", unlocked_by: "some content"}
  @invalid_attrs %{}

  test "changeset with valid attributes" do
    changeset = Video.changeset(%Video{}, @valid_attrs)
    assert changeset.valid?
  end

  test "changeset with invalid attributes" do
    changeset = Video.changeset(%Video{}, @invalid_attrs)
    refute changeset.valid?
  end
end
