defmodule Manager.StreamController do
  use Manager.Web, :controller
  require IEx

  def file_list(conn, %{"id" => id}) do
    render conn, "file_list.txt"
  end

  def file(conn, %{"encoded_path" => encoded_path}) do
    url = Base.decode64!(String.slice(encoded_path, 0..-5))
    HTTPoison.get!(url, conn.req_headers, stream_to: self)
    process_proxy_request(conn)
  end

  def process_proxy_request(conn) do
    receive do
      %HTTPoison.AsyncStatus{code: code} ->
        process_proxy_request(put_status(conn, code))
      %HTTPoison.AsyncHeaders{headers: headers} ->
        process_proxy_request(merge_resp_headers(conn,headers))
      %HTTPoison.AsyncChunk{chunk: chunk} ->
        conn = case conn.state do
          :chunked -> conn
          _ -> send_chunked(conn, conn.status)
        end
        {:ok, conn} = chunk(conn,chunk)
        process_proxy_request(conn)
      %HTTPoison.AsyncEnd{} -> conn
     end
  end


end
