defmodule Manager.Channel do
  use Manager.Web, :model

  schema "channels" do
    field :name, :string
    field :stream_key, :string

    timestamps()
  end

  @doc """
  Builds a changeset based on the `struct` and `params`.
  """
  def changeset(struct, params \\ %{}) do
    struct
    |> cast(params, [:name, :stream_key])
    |> validate_required([:name, :stream_key])
  end
end
