defmodule Manager.Router do
  use Manager.Web, :router

  pipeline :browser do
    plug :accepts, ["html"]
    plug :fetch_session
    plug :fetch_flash
    plug :protect_from_forgery
    plug :put_secure_browser_headers
  end

  pipeline :api do
    plug :accepts, ["json"]
  end

  scope "/", Manager do
    pipe_through :browser # Use the default browser stack

    resources "/videos", VideoController, only: [:show, :index]
    resources "/channels", ChannelController, except: [:new, :edit]

    get "/file_list/:id/:encoded_path", StreamController, :file
    get "/file_list/:id", StreamController, :file_list
  end

  # Other scopes may use custom stacks.
  # scope "/api", Manager do
  #   pipe_through :api
  # end
end
