defmodule Manager.ChannelView do
  use Manager.Web, :view

  def render("index.json", %{channels: channels}) do
    %{data: render_many(channels, Manager.ChannelView, "channel.json")}
  end

  def render("show.json", %{channel: channel}) do
    %{data: render_one(channel, Manager.ChannelView, "channel.json")}
  end

  def render("channel.json", %{channel: channel}) do
    %{id: channel.id,
      name: channel.name,
      stream_key: channel.stream_key}
  end
end
