defmodule Manager.VideoView do
  use Manager.Web, :view

  def render("index.json", %{videos: videos}) do
    %{data: render_many(videos, Manager.VideoView, "video.json")}
  end

  def render("show.json", %{video: video}) do
    %{data: render_one(video, Manager.VideoView, "video.json")}
  end

  def render("video.json", %{video: video}) do
    %{id: video.id,
      title: video.title,
      show: video.show,
      season: video.season,
      s3_path: video.s3_path,
      channel_id: video.channel_id,
      length: video.length,
      unlocked_by: video.unlocked_by}
  end
end
