defmodule Streamer do
  use Application

  # See http://elixir-lang.org/docs/stable/elixir/Application.html
  # for more information on OTP Applications
  def start(_type, _args) do
    import Supervisor.Spec, warn: false

    # Define workers and child supervisors to be supervised
    children = [
      # Starts a worker by calling: Streamer.Worker.start_link(arg1, arg2, arg3)
      # worker(Streamer.Worker, [arg1, arg2, arg3]),
    ]

    # See http://elixir-lang.org/docs/stable/elixir/Supervisor.html
    # for other strategies and supported options
    opts = [strategy: :one_for_one, name: Streamer.Supervisor]
    Supervisor.start_link(children, opts)
  end

  defmodule GoStreamer do
    import FFmpex
    use FFmpex.Options

    def begin_stream(stream_key) do
      {_, 0} = System.cmd("ffmpeg",[
        "-protocol_whitelist", "file,http,https,tcp,tls",
    		"-re",
    		"-auto_convert", "1",
    		"-segment_time_metadata", "1",
        "-safe", "0",
    		"-f", "concat",
    		"-i", "./file_list-1.ffconcat",
    		"-c", "copy",
    		"-f", "flv",
    		"rtmp://live.twitch.tv/app/"<>stream_key,
    		"-loglevel", "trace",
     ], stderr_to_stdout: true)
    end


  end
end

# FFmpex.new_command
# |> add_global_option(option_y)
# |> add_input_file("/path/to/input.avi")
# |> add_output_file("/path/to/output.avi")
#   |> add_stream_specifier(stream_type: :video)
#     |> add_stream_option(option_b("64k"))
#   |> add_file_option(option_maxrate("128k"))
#   |> add_file_option(option_bufsize("64k"))

# command = FFmpex.new_command
# |> add_global_option(option_y)
# |> add_input_file(input_string)
# |> add_output_file(timelapse_path)
#   |> add_file_option(option_vcodec("libx264"))
#   |> add_file_option(option_preset("fast"))
#   |> add_file_option(option_pix_fmt("yuv420p"))
#   |> add_file_option(option_pix_fmt("yuv420p"))
#   |> add_file_option(option_s("1280x800"))
#   |> add_file_option(option_f("flv"))
#   |> add_file_option(option_flags("+genpts"))
