##
# Outputs that describe shared resources such as VPC, Subnets, SGs
##

# VPC ID
output "vpc_id" {
	value = "${module.web_vpc.vpc_id}"
}

output "account_id" {
	value = "641044725657"
}

# SUBNET IDS
output "service_a" {
	value = "${module.web_subnets.service_a}"
}

output "service_b" {
	value = "${module.web_subnets.service_b}"
}

output "service_c" {
	value = "${module.web_subnets.service_c}"
}

output "service_subnets" {
	value = "${module.web_subnets.service_a},${module.web_subnets.service_b},${module.web_subnets.service_c}"
}

output "data_a" {
	value = "${module.web_subnets.data_a}"
}

output "data_b" {
	value = "${module.web_subnets.data_b}"
}

output "data_c" {
	value = "${module.web_subnets.data_c}"
}

output "data_subnets" {
	value = "${module.web_subnets.data_a},${module.web_subnets.data_b},${module.web_subnets.data_c}"
}

output "caching_a" {
	value = "${module.web_subnets.caching_a}"
}

output "caching_b" {
	value = "${module.web_subnets.caching_b}"
}

output "caching_c" {
	value = "${module.web_subnets.caching_c}"
}

output "caching_subnets" {
	value = "${module.web_subnets.caching_a},${module.web_subnets.caching_b},${module.web_subnets.caching_c}"
}

output "routing_a" {
	value = "${module.web_subnets.routing_a}"
}

output "routing_b" {
	value = "${module.web_subnets.routing_b}"
}

output "routing_c" {
	value = "${module.web_subnets.routing_c}"
}

output "routing_subnets" {
	value = "${module.web_subnets.routing_a},${module.web_subnets.routing_b},${module.web_subnets.routing_c}"
}

output "public_a" {
	value = "${module.web_subnets.public_a}"
}

output "public_b" {
	value = "${module.web_subnets.public_b}"
}

output "public_c" {
	value = "${module.web_subnets.public_c}"
}

output "public_subnets" {
	value = "${module.web_subnets.public_a},${module.web_subnets.public_b},${module.web_subnets.public_c}"
}

# SECURITY GROUPS
output "twitch_subnets_sg" {
	value = "${module.twitch_subnets.id}"
}

# NAT Gateway
output "nat_gw_a_public_ip" {
	value = "${module.nat_gw.gw_a_public_ip}"
}

output "nat_gw_b_public_ip" {
	value = "${module.nat_gw.gw_b_public_ip}"
}

output "nat_gw_c_public_ip" {
	value = "${module.nat_gw.gw_c_public_ip}"
}
