variable sfo_dx {
	default = "vgw-efb069f1"
}

variable twitch_web_aws_production_peering {
	default = "pcx-bda902d4"
}


variable redislabs_peering {
	default = "pcx-f54ee59c"
}

# Peering Connections
resource "aws_vpc_peering_connection" "science_peer" {
	peer_owner_id = "673385534282"
	peer_vpc_id = "vpc-0713b162"
	vpc_id = "${module.web_vpc.vpc_id}"
	tags {
		Name = "twitch-science/science"
	}
}


# Peering Connections
resource "aws_vpc_peering_connection" "science_production_peer" {
	peer_owner_id = "673385534282"
	peer_vpc_id = "vpc-0213b167"
	vpc_id = "${module.web_vpc.vpc_id}"
	tags {
		Name = "twitch-science/production"
	}
}

# resource "aws_vpc_peering_connection" "passport_peer" {
#     peer_owner_id = "052331484169"
#     peer_vpc_id = "vpc-916af5f4"
#     vpc_id = "${module.web_vpc.vpc_id}"
#     tags {
# 		Name = "twitch-passport/production"
# 	}
# }

# Currently Staging lives inside Development VPC
resource "aws_vpc_peering_connection" "twitch_aws_peer_dev" {
	peer_owner_id = "673385534282"
    peer_vpc_id = "vpc-1e13b17b"
    vpc_id = "${module.web_vpc.vpc_id}"
    tags {
		Name = "twitch-aws/development"
	}
}

# resource "aws_vpc_peering_connection" "video_peer" {
#     peer_owner_id = "848744099708"
#     peer_vpc_id = "vpc-cae782af"
#     vpc_id = "${module.web_vpc.vpc_id}"
#     tags {
# 		Name = "twitch-video/production"
# 	}
# }

# resource "aws_vpc_peering_connection" "chat_peer" {
#     peer_owner_id = "603200399373"
#     peer_vpc_id = "vpc-6183fe04"
#     vpc_id = "${module.web_vpc.vpc_id}"
#     tags {
# 		Name = "twitch-chat/production"
# 	}
# }

# resource "aws_vpc_peering_connection" "rlec_peer" {
#     peer_owner_id = "673337243802"
#     peer_vpc_id = "vpc-ca2e33af"
#     vpc_id = "${module.web_vpc.vpc_id}"
#     tags {
# 		Name = "twitch-rlec/development"
# 	}
# }


## Route Tables
resource "aws_route_table" "external" {
	vpc_id = "${module.web_vpc.vpc_id}"

	tags {
		Name = "external_routes"
		Owner = "${var.owner}"
	}

	route {
		cidr_block = "0.0.0.0/0"
		gateway_id = "${module.web_vpc.igw_id}"
	}

  route {
		cidr_block = "10.192.0.0/18"
		vpc_peering_connection_id = "${aws_vpc_peering_connection.science_peer.id}"
	}

	route {
		cidr_block = "10.192.64.0/18"
		vpc_peering_connection_id = "${aws_vpc_peering_connection.science_production_peer.id}"
	}

  route {
		cidr_block = "10.192.128.0/18"
		vpc_peering_connection_id = "${aws_vpc_peering_connection.twitch_aws_peer_dev.id}"
	}

	route {
		cidr_block = "10.194.192.0/18"
		vpc_peering_connection_id = "${var.twitch_web_aws_production_peering}"
	}

	route {
		cidr_block = "10.195.128.0/18"
		vpc_peering_connection_id = "${var.redislabs_peering}"
	}

	# route {
	# 	cidr_block = "10.192.192.0/18"
	# 	vpc_peering_connection_id = "${aws_vpc_peering_connection.passport_peer.id}"
	# }

	# route {
	# 	cidr_block = "10.193.0.0/18"
	# 	vpc_peering_connection_id = "${aws_vpc_peering_connection.video_peer.id}"
	# }

	# route {
	# 	cidr_block = "10.193.192.0/18"
	# 	vpc_peering_connection_id = "${aws_vpc_peering_connection.chat_peer.id}"
	# }

	# route {
	# 	cidr_block = "10.195.160.0/19"
	# 	vpc_peering_connection_id = "${aws_vpc_peering_connection.rlec_peer.id}"
	# }

	propagating_vgws = ["${var.sfo_dx}"]
}

resource "aws_route_table" "internal_a" {
	vpc_id = "${module.web_vpc.vpc_id}"

	tags {
		Name = "internal_routes_a"
		Owner = "${var.owner}"
	}

	route {
		cidr_block = "0.0.0.0/0"
		nat_gateway_id = "${module.nat_gw.gw_a}"
	}

	route {
		cidr_block = "10.192.0.0/18"
		vpc_peering_connection_id = "${aws_vpc_peering_connection.science_peer.id}"
	}

	route {
		cidr_block = "10.192.64.0/18"
		vpc_peering_connection_id = "${aws_vpc_peering_connection.science_production_peer.id}"
	}

	route {
		cidr_block = "10.192.128.0/18"
		vpc_peering_connection_id = "${aws_vpc_peering_connection.twitch_aws_peer_dev.id}"
	}

	route {
		cidr_block = "10.194.192.0/18"
		vpc_peering_connection_id = "${var.twitch_web_aws_production_peering}"
	}

	route {
		cidr_block = "10.195.128.0/18"
		vpc_peering_connection_id = "${var.redislabs_peering}"
	}

	# route {
	# 	cidr_block = "10.192.192.0/18"
	# 	vpc_peering_connection_id = "${aws_vpc_peering_connection.passport_peer.id}"
	# }

	# route {
	# 	cidr_block = "10.193.0.0/18"
	# 	vpc_peering_connection_id = "${aws_vpc_peering_connection.video_peer.id}"
	# }

	# route {
	# 	cidr_block = "10.193.192.0/18"
	# 	vpc_peering_connection_id = "${aws_vpc_peering_connection.chat_peer.id}"
	# }

	# route {
	# 	cidr_block = "10.195.160.0/19"
	# 	vpc_peering_connection_id = "${aws_vpc_peering_connection.rlec_peer.id}"
	# }

	propagating_vgws = ["${var.sfo_dx}"]
}

resource "aws_route_table" "internal_b" {
	vpc_id = "${module.web_vpc.vpc_id}"

	tags {
		Name = "internal_routes_b"
		Owner = "${var.owner}"
	}

	route {
		cidr_block = "0.0.0.0/0"
		nat_gateway_id = "${module.nat_gw.gw_b}"
	}

	route {
		cidr_block = "10.192.0.0/18"
		vpc_peering_connection_id = "${aws_vpc_peering_connection.science_peer.id}"
	}

	route {
		cidr_block = "10.192.64.0/18"
		vpc_peering_connection_id = "${aws_vpc_peering_connection.science_production_peer.id}"
	}

	route {
		cidr_block = "10.192.128.0/18"
		vpc_peering_connection_id = "${aws_vpc_peering_connection.twitch_aws_peer_dev.id}"
	}

	route {
		cidr_block = "10.194.192.0/18"
		vpc_peering_connection_id = "${var.twitch_web_aws_production_peering}"
	}

	route {
		cidr_block = "10.195.128.0/18"
		vpc_peering_connection_id = "${var.redislabs_peering}"
	}

	# route {
	# 	cidr_block = "10.192.192.0/18"
	# 	vpc_peering_connection_id = "${aws_vpc_peering_connection.passport_peer.id}"
	# }

	# route {
	# 	cidr_block = "10.193.0.0/18"
	# 	vpc_peering_connection_id = "${aws_vpc_peering_connection.video_peer.id}"
	# }

	# route {
	# 	cidr_block = "10.193.192.0/18"
	# 	vpc_peering_connection_id = "${aws_vpc_peering_connection.chat_peer.id}"
	# }

	# route {
	# 	cidr_block = "10.195.160.0/19"
	# 	vpc_peering_connection_id = "${aws_vpc_peering_connection.rlec_peer.id}"
	# }

	propagating_vgws = ["${var.sfo_dx}"]
}

resource "aws_route_table" "internal_c" {
	vpc_id = "${module.web_vpc.vpc_id}"

	tags {
		Name = "internal_routes_c"
		Owner = "${var.owner}"
	}

	route {
		cidr_block = "0.0.0.0/0"
		nat_gateway_id = "${module.nat_gw.gw_c}"
	}

	route {
		cidr_block = "10.192.0.0/18"
		vpc_peering_connection_id = "${aws_vpc_peering_connection.science_peer.id}"
	}

	route {
		cidr_block = "10.192.64.0/18"
		vpc_peering_connection_id = "${aws_vpc_peering_connection.science_production_peer.id}"
	}


	route {
		cidr_block = "10.192.128.0/18"
		vpc_peering_connection_id = "${aws_vpc_peering_connection.twitch_aws_peer_dev.id}"
	}

	route {
		cidr_block = "10.194.192.0/18"
		vpc_peering_connection_id = "${var.twitch_web_aws_production_peering}"
	}

	route {
		cidr_block = "10.195.128.0/18"
		vpc_peering_connection_id = "${var.redislabs_peering}"
	}

	# route {
	# 	cidr_block = "10.192.192.0/18"
	# 	vpc_peering_connection_id = "${aws_vpc_peering_connection.passport_peer.id}"
	# }

	# route {
	# 	cidr_block = "10.193.0.0/18"
	# 	vpc_peering_connection_id = "${aws_vpc_peering_connection.video_peer.id}"
	# }

	# route {
	# 	cidr_block = "10.193.192.0/18"
	# 	vpc_peering_connection_id = "${aws_vpc_peering_connection.chat_peer.id}"
	# }

	# route {
	# 	cidr_block = "10.195.160.0/19"
	# 	vpc_peering_connection_id = "${aws_vpc_peering_connection.rlec_peer.id}"
	# }

	propagating_vgws = ["${var.sfo_dx}"]
}

## Route Table Associations
resource "aws_route_table_association" "route_public_a" {
	subnet_id = "${module.web_subnets.public_a}"
	route_table_id = "${aws_route_table.external.id}"
}

resource "aws_route_table_association" "route_public_b" {
	subnet_id = "${module.web_subnets.public_b}"
	route_table_id = "${aws_route_table.external.id}"
}

resource "aws_route_table_association" "route_public_c" {
	subnet_id = "${module.web_subnets.public_c}"
	route_table_id = "${aws_route_table.external.id}"
}

resource "aws_route_table_association" "route_service_a" {
	subnet_id = "${module.web_subnets.service_a}"
	route_table_id = "${aws_route_table.internal_a.id}"
}

resource "aws_route_table_association" "route_service_b" {
	subnet_id = "${module.web_subnets.service_b}"
	route_table_id = "${aws_route_table.internal_b.id}"
}

resource "aws_route_table_association" "route_service_c" {
	subnet_id = "${module.web_subnets.service_c}"
	route_table_id = "${aws_route_table.internal_c.id}"
}

resource "aws_route_table_association" "route_caching_a" {
	subnet_id = "${module.web_subnets.caching_a}"
	route_table_id = "${aws_route_table.internal_a.id}"
}

resource "aws_route_table_association" "route_caching_b" {
	subnet_id = "${module.web_subnets.caching_b}"
	route_table_id = "${aws_route_table.internal_b.id}"
}

resource "aws_route_table_association" "route_caching_c" {
	subnet_id = "${module.web_subnets.caching_c}"
	route_table_id = "${aws_route_table.internal_c.id}"
}

resource "aws_route_table_association" "route_routing_a" {
	subnet_id = "${module.web_subnets.routing_a}"
	route_table_id = "${aws_route_table.internal_a.id}"
}

resource "aws_route_table_association" "route_routing_b" {
	subnet_id = "${module.web_subnets.routing_b}"
	route_table_id = "${aws_route_table.internal_b.id}"
}

resource "aws_route_table_association" "route_routing_c" {
	subnet_id = "${module.web_subnets.routing_c}"
	route_table_id = "${aws_route_table.internal_c.id}"
}

resource "aws_route_table_association" "route_data_a" {
	subnet_id = "${module.web_subnets.data_a}"
	route_table_id = "${aws_route_table.internal_a.id}"
}

resource "aws_route_table_association" "route_data_b" {
	subnet_id = "${module.web_subnets.data_b}"
	route_table_id = "${aws_route_table.internal_b.id}"
}

resource "aws_route_table_association" "route_data_c" {
	subnet_id = "${module.web_subnets.data_c}"
	route_table_id = "${aws_route_table.internal_c.id}"
}
