module "web_vpc" {
	source = "git::git+ssh://git@git-aws.internal.justin.tv/web/terraform.git//modules/vpc"
	name = "${var.vpc.name}"
	owner = "${var.owner}"
	cidr = "${var.vpc.cidr}"
}

module "web_subnets" {
	source = "git::git+ssh://git@git-aws.internal.justin.tv/web/terraform.git//modules/web-subnets"
	vpc_id = "${module.web_vpc.vpc_id}"
	owner = "${var.owner}"
	service_a = "${cidrsubnet(var.vpc.cidr, 3, 0)}"
	service_b = "${cidrsubnet(var.vpc.cidr, 3, 2)}"
	service_c = "${cidrsubnet(var.vpc.cidr, 3, 4)}"
	data_a    = "${cidrsubnet(var.vpc.cidr, 6, 48)}"
	data_b    = "${cidrsubnet(var.vpc.cidr, 6, 50)}"
	data_c    = "${cidrsubnet(var.vpc.cidr, 6, 52)}"
	caching_a = "${cidrsubnet(var.vpc.cidr, 6, 54)}"
	caching_b = "${cidrsubnet(var.vpc.cidr, 6, 55)}"
	caching_c = "${cidrsubnet(var.vpc.cidr, 6, 56)}"
	routing_a = "${cidrsubnet(var.vpc.cidr, 6, 57)}"
	routing_b = "${cidrsubnet(var.vpc.cidr, 6, 58)}"
	routing_c = "${cidrsubnet(var.vpc.cidr, 6, 59)}"
	public_a  = "${cidrsubnet(var.vpc.cidr, 6, 60)}"
	public_b  = "${cidrsubnet(var.vpc.cidr, 6, 61)}"
	public_c  = "${cidrsubnet(var.vpc.cidr, 6, 62)}"
}

module "twitch_subnets" {
	source = "git::git+ssh://git@git-aws.internal.justin.tv/web/terraform.git//modules/sg"
	owner = "${var.owner}"
	vpc_id = "${module.web_vpc.vpc_id}"
}

resource "aws_elasticache_subnet_group" "general-elasticache-subnets" {
	name = "general-elasticache-subnets"
	description = "place elasticache instances in the cache subnet"
	subnet_ids =["${module.web_subnets.caching_a}",
				"${module.web_subnets.caching_b}",
				"${module.web_subnets.caching_c}"]
}

#resource "aws_vpn_gateway" "vpn_gw" {
#  vpc_id = "${module.web_vpc.vpc_id}"
#  tags {
#    Name = "dx"
#  }
#}
