import React, { Component } from 'react';
import './App.css';
import MetadataBox from'./components/metadata-box';
import TimelineBox from'./components/timeline-box';
import Video from'./components/video';

class App extends Component {
  constructor(props) {
    super(props);
    this.state = {
      assets: [
        {
          "id": 4,
          "url": "https://s3-us-west-2.amazonaws.com/twitch-creative-assets/public/Rick+Astley+-+Never+Gonna+Give+You+Up.mp4"
        },
        {
          "id": 3,
          "url": "https://s3-us-west-2.amazonaws.com/twitch-creative-assets/public/SampleVideo_1280x720_10mb.mp4"
        }
      ],
      "selected": "intro",
      "id": "project_name",
      "channel": "lirik",
      "currentMetaTime": 0,
      "version": 1,
      "events": [
        {
          "id": "intro",
          "layer_id": "video1",
          "type": "video",
          "asset_id": 4,
          "duration": 100,
          "offset": 10,
          "events": [
          ]
        },
        {
          "id": "timeWarp1",
          "type": "timeWarp",
          "layer_id": "timeWarps",
          "duration": 0,
          "sourceTime": 5,
          "destinationTime": 5,
          "events": [
          ]
        },
        {
          "id": "timeWarp2",
          "type": "timeWarp",
          "layer_id": "timeWarps",
          "duration": 0,
          "sourceTime": 100,
          "destinationTime": 20,
          "events": [
          ]
        },
        {
          "id": "timeWarp3",
          "type": "timeWarp",
          "layer_id": "timeWarps",
          "duration": 0,
          "sourceTime": 110,
          "destinationTime": 30,
          "events": [
          ]
        },
        {
          "id": "outro",
          "layer_id": "video1",
          "type": "video",
          "asset_id": 3,
          "offset": 5,
          "duration": 10,
          "events": [
          ]
        }
      ]
    }
  }

  fetchSelected(state, selection) {
    //base case
    if(selection === state.id) return state;

    return state.events.map((event)=> {
      return this.fetchSelected(event, selection);
    }).filter((event) => event)[0];
  }

  timeUpdater(currentMetaTime) {
    this.setState({currentMetaTime: currentMetaTime})
  }

  render() {
    return (
      <div className="app">
        <div className="top">
          <div className="video-player left">
            <h1 className="title">{this.state.id}</h1>
            <Video
              events={this.state.events}
              assets={this.state.assets}
              handleUpdateTime={this.timeUpdater.bind(this)}
              currentMetaTime={this.state.currentMetaTime}
              // currentVideoEventID={this.state.currentVideoEventID}
              />
          </div>
          <div className="asset-list right" >Asset List</div>
        </div>
        <div className="bottom">
          <div className="timeline-box left">
            Timeline Box
            <TimelineBox events={this.state.events} />
          </div>
          <div className="metadata right">
            MetadataBox
            <MetadataBox event={this.fetchSelected(this.state, this.state.selected)}/>
          </div>
        </div>
      </div>
    );
  }
}

export default App;
