import React, { PropTypes } from 'react';
import VideoSegment from './video-segment';

class TimelineBox extends React.Component {
  constructor(props) {
    super(props);
    // debugger;
    this.state = {
      layers: this.props.events
    }
  }

  groupByLayer(events) {
      return events.reduce((accum, event) => {
        accum[event.layer_id] = accum[event.layer_id] || [];
        accum[event.layer_id].push(event);
        return accum;
      }, {});
  }

  createSegments(layer) {
    return layer.map(event => (
      <VideoSegment key={event.id} event={event} />
    ));
  }

  render() {
    return (
      <div className="layer">
        {this.createSegments(this.state.layers)}
      </div>
    );
  }
}

export default TimelineBox;
