import React from 'react';
const MAX_TIME_RIFT = 0.01

class Video extends React.Component {
  constructor(props) {
    super(props);
    let videoProps = this.getVideoProps(this.props.events, this.props.assets, this.props.currentMetaTime);
    this.state = {
      currentVideoEvent: videoProps.currentVideoEvent,
      playerState: "paused"
    }
  }

  getVideoProps(events, assets, currentMetaTime) {
    let videos = events.filter((event) => event.type === 'video')
    let totalDuration = videos.reduce((sum, event) => sum + event.duration, 0)
    let timeWarps = events.filter((event) => event.type === 'timeWarp')
    let firstWarp = {
      "type": "timeWarp",
      "sourceTime": 0,
      "destinationTime": 0,
    }
    let lastWarp = {
      "type": "timeWarp",
      "sourceTime": totalDuration,
      "destinationTime": totalDuration,
    }
    let zippedTimeWarps = [[firstWarp, timeWarps[0]]].concat(timeWarps.map((tw, i)=> [tw, timeWarps[i + 1] || lastWarp]));
    let [startWarp, endWarp] = zippedTimeWarps.find(([s, e], idx) =>(s.destinationTime <= currentMetaTime && e.destinationTime > currentMetaTime) || idx === zippedTimeWarps.length - 1);
    let currentPlaybackRate =  (endWarp.sourceTime - startWarp.sourceTime) / (endWarp.destinationTime - startWarp.destinationTime);
    let portionOfCurrentWarpCompleteInSeconds = currentMetaTime - startWarp.destinationTime;
    let percentageOfCurrentTimeWarpComplete = portionOfCurrentWarpCompleteInSeconds / (endWarp.destinationTime - startWarp.destinationTime);
    let unwarpedCurrentTime = percentageOfCurrentTimeWarpComplete * (endWarp.sourceTime - startWarp.sourceTime) + startWarp.sourceTime;
    let videosWithTimestamp = videos.reduce((accum, v) => {
      let lastVideo = accum[accum.length - 1] || {}
      let video = Object.assign(
        {timestamp: (lastVideo.timestamp || 0) + (lastVideo.duration || 0) },
        v
      )
      accum.push(video)
      return accum
    }, [])
    let currentVideoEvent = videosWithTimestamp.find((v, i) => {
      return !videosWithTimestamp[i + 1] || videosWithTimestamp[i + 1].timestamp >= unwarpedCurrentTime
    });
    let currentURL = assets.find((a)=> a.id === currentVideoEvent.asset_id).url;
    let currentTime = unwarpedCurrentTime - currentVideoEvent.timestamp + currentVideoEvent.offset
    return {
      src: currentURL + `#t=${currentVideoEvent.offset},${currentVideoEvent.duration + currentVideoEvent.offset}`,
      playbackRate: currentPlaybackRate,
      currentVideoEvent: currentVideoEvent,
      currentTime: currentTime,
      totalDuration: totalDuration,
    }
  }

  getStyle(id) {
    return {
      display: id === this.state.currentVideoEvent.id ? "block" : "none",
    }
  }

  createVideoEvents(events) {
    return events.filter(e => e.type === 'video').map(event => {
      let asset = this.props.assets.find(asset => asset.id === event.asset_id)
      let src = asset.url + `#t=${event.offset},${event.duration + event.offset}`
      return <video height="360" width="640" src={src} className={event.id} key={event.id} style={this.getStyle(event.id)}> </video>
    })
  }

  render() {
    return (
      <div className="videos">
        {this.createVideoEvents(this.props.events)}
        <button onClick={this.togglePlayerState.bind(this)}>{this.state.playerState}</button>
      </div>
    );
  }

  togglePlayerState() {
    let newPlayerState = this.state.playerState === 'paused' ? 'playing' : 'paused'
    this.setState({playerState: newPlayerState})
  }

  warpTime(events, assets, unwarpedMetaTime) {
    let videos = events.filter((event) => event.type === 'video')
    let totalUnwarpedDuration = videos.reduce((sum, event) => sum + event.duration, 0)
    let timeWarps = events.filter((event) => event.type === 'timeWarp')
    let lastWarp = timeWarps[timeWarps.length - 1]
    let totalDuration = totalUnwarpedDuration - lastWarp.sourceTime + lastWarp.destinationTime
    let implicitFirstWarp = {
      "type": "timeWarp",
      "sourceTime": 0,
      "destinationTime": 0,
    }
    let implicitLastWarp = {
      "type": "timeWarp",
      "sourceTime": totalUnwarpedDuration,
      "destinationTime": totalDuration,
    }
    let zippedTimeWarps = [[implicitFirstWarp, timeWarps[0]]].concat(timeWarps.map((tw, i)=> [tw, timeWarps[i + 1] || implicitLastWarp]));
    let [startWarp, endWarp] = zippedTimeWarps.find(([s, e], idx) => (s.sourceTime <= unwarpedMetaTime && e.sourceTime > unwarpedMetaTime) || idx === zippedTimeWarps.length - 1);
    let portionOfCurrentWarpCompletedInUnwarpedSeconds = unwarpedMetaTime - startWarp.sourceTime;
    let percentageOfCurrentWarpComplete = portionOfCurrentWarpCompletedInUnwarpedSeconds / (endWarp.sourceTime - startWarp.sourceTime);
    let warpedCurrentTime = percentageOfCurrentWarpComplete * (endWarp.destinationTime - startWarp.destinationTime) + startWarp.destinationTime;
    return warpedCurrentTime
  }

  componentDidMount() {
    let videos = Array.prototype.slice.call(document.getElementsByTagName('video'));
    videos.forEach( video => {
      video.addEventListener("timeupdate", (e) => {
        let currentVideoEvent = this.getVideoProps(this.props.events, this.props.assets, this.props.currentMetaTime).currentVideoEvent;
        if(currentVideoEvent.id === e.target.className.split(" ")[0]) {
          let unwarpedMetaTime = (e.target.currentTime - currentVideoEvent.offset) + currentVideoEvent.timestamp
          let metaTime = this.warpTime(this.props.events, this.props.assets, unwarpedMetaTime)
          this.props.handleUpdateTime(metaTime)
        }
      })
    })
    this.refreshVideo()
  }

  componentDidUpdate() {
    this.refreshVideo()
  }

  refreshVideo() {
    let videoProps = this.getVideoProps(this.props.events, this.props.assets, this.props.currentMetaTime);
    if(this.state.currentVideoEvent.id !== videoProps.currentVideoEvent.id) this.setState({currentVideoEvent: videoProps.currentVideoEvent})
    let videos = Array.prototype.slice.call(document.getElementsByTagName('video'));
    let video = videos.find(v => v.className.split(" ")[0] === videoProps.currentVideoEvent.id)
    if(video.paused && !video.ended && this.props.currentMetaTime < videoProps.totalDuration &&  this.state.playerState === 'playing') video.play()
    if((video.currentTime > 0 && !video.paused) && this.state.playerState === 'paused') video.pause()
    if(this.props.currentMetaTime >= videoProps.totalDuration && this.state.playerState !== 'paused') {
      this.togglePlayerState()
      video.pause()
    }
    video.playbackRate = videoProps.playbackRate;
    if(Math.abs(video.currentTime - videoProps.currentTime) > MAX_TIME_RIFT) video.currentTime = videoProps.currentTime;
  }
}

export default Video;
