# This file is responsible for configuring your application
# and its dependencies with the aid of the Mix.Config module.
#
# This configuration file is loaded before any dependency and
# is restricted to this project.
use Mix.Config

# General application configuration
config :timelapser,
  ecto_repos: [Timelapser.Repo]

# Configures the endpoint
config :timelapser, Timelapser.Endpoint,
  url: [host: "localhost"],
  secret_key_base: "s500rYBLmToAn1O/idBYkOsFdp5t0h7lHhNGk3OEBASqxGeEM2oCcMQz54OSnJR1",
  render_errors: [view: Timelapser.ErrorView, accepts: ~w(json)],
  pubsub: [name: Timelapser.PubSub,
           adapter: Phoenix.PubSub.PG2]

# Configures Elixir's Logger
config :logger, :console,
  format: "$time $metadata[$level] $message\n",
  metadata: [:request_id]

# Import environment specific config. This must remain at the bottom
# of this file so it overrides the configuration defined above.
import_config "#{Mix.env}.exs"
