
## Create Opening Title
draws black background with centered white text (w/o quotes)'Recorded by <username> on Twitch'
1280x800, for 2 seconds, sets output framerate to 30fps, outputs to title.mp4
```
ffmpeg -y -f lavfi -i color=c=black:s=1280x800:d=2.0 -vf \
"drawtext=fontfile=./Korolev_bold.otf:fontsize=30: \
 fontcolor=white:x=(w-text_w)/2:y=(h-text_h)/2:text='Recorded by <username> on Twitch'" -r 30 \
title.mp4
```
## Create Ending Credits
draws black background with centered white text (w/o quotes) 'twitch.tv/<username>'
 1280x800, for 2 seconds, sets output framerate to 30fps, outputs to title.mp4
```
ffmpeg -y -f lavfi -i color=c=black:s=1280x800:d=1.0 -vf \
"drawtext=fontfile=./Korolev_bold.otf:fontsize=30: \
 fontcolor=white:x=(w-text_w)/2:y=(h-text_h)/2:text='twitch.tv/<username>'" -r 30 \
end.mp4
```

## Combine Audio and Video with encoding for Upload
Combines Audio and Video `-ss : starting point to cut`, `-t : length of segment in seconds`, `-acodec: audio encoding`
```
ffmpeg -y -t 30 -i "output.mp4" -t 30 -i "timelapse_audio.mp3" -map 0:v:0 -map 1:a:0 \
-c:v libx264 -preset fast -pix_fmt yuv420p -s 1280x800 -threads 0 -f flv -acodec aac -r 30 -fflags +genpts \
qwer.mp4
```


```
ffmpeg -ss 00:00:00  -t 30 -i "ross.mp4" -ss 0:00:00 -t 30 -i "timelapse_audio.mp3" -map 0:v:0 -map 1:a:0 -y  out.mp4
```

## Audio Splice and Fade-in Fade-out
// Extract 30 seconds of audio beginning at 3 seconds into the file and output to "achunk.mp3"
```
ffmpeg -i Beethoven_Piano_Concerto_No3_Op37_I.mp3 -ss 3 -t 30 achunk.mp3
```
// Takes timelapse_audio.mp3, adds fade-in effect, starts at 0 secs (default), ands lasts 2 secs, adds fade-out effect, starts at 28 seconds and last for 2 seconds, outputs to "timelapse_audio.mp3"
```
ffmpeg -i timelapse_audio.mp3 -af 'afade=t=in:d=2,afade=t=out:st=28:d=2' -vn -sn -c:a mp3 timelapse_audio.mp3
```

// Concats .mp4 files using a file list
// overwrites, concats, reads any path (safe or unsafe), reads for file.txt, copys codecs, outputs to output.mp4
```
ffmpeg -y -f concat -safe 0 -i file.txt -c copy output.mp4
```

// concat a bunch of .png frames
```
ffmpeg -i test.txt
-y -c:v libx264 -preset fast -pix_fmt yuv420p -s 1280x800 -threads 0 -f concat -fflags +genpts -r 30 TEST.mp4
```
// -r 30              // output fps
// -framerate 30      // input rate

### random copy pastas from stack overflow to deal with concating .mp4
```
ffmpeg -i title -i main -y -filter_complex '[0:0] setsar=1/1[sarfix];[sarfix] [1:0] concat=n=2:v=1:a=0 [v]' -map '[v]' -pass 1 -strict -2 -an -vcodec libx264 -pix_fmt yuv420p -aspect 16:9 -threads 4 -b:v 2400k -flags +loop -cmp chroma -partitions +parti4x4+partp8x8+partb8x8 -subq 1 -trellis 0 -refs 1 -bf 3 -b_strategy 2 -coder 1 -me_range 16 -g 250 -keyint_min 75 -sc_threshold 40 -i_qfactor 0.71 -rc_eq 'blurCplx^(1-qComp)' -qcomp 0.6 -qmin 10 -qmax 51 -qdiff 4 output.mp4

ffmpeg -i title -i main -y -filter_complex '[0:0] setsar=1/1[sarfix];[sarfix] [0:1] [1:0] [1:1] concat=n=2:v=1:a=1[v] [a]' -map '[v]' -map '[a]' -strict -2 -acodec aac -b:a 128k -pass 2 -vcodec libx264 -pix_fmt yuv420p -aspect 16:9 -threads 4 -b:v 2400k -flags +loop -cmp chroma -partitions +parti4x4+partp8x8+partb8x8 -mixed-refs 1 -subq 6 -trellis 1 -refs 5 -bf 3 -b_strategy 2 -coder 1 -me_range 16 -g 250 -keyint_min 75 -sc_threshold 40 -i_qfactor 0.71 -rc_eq 'blurCplx^(1-qComp)' -qcomp 0.6 -qmin 10 -qmax 51 -qdiff 4 output.mp4
```








ffmpeg -y -f lavfi -i color=c=black:s=1280x800:d=2.0 -vf \
"drawtext=fontfile=./Korolev_bold.otf:fontsize=30: \
 fontcolor=white:x=(w-text_w)/2:y=(h-text_h)/2:text='Recorded by <username> on Twitch' \
 ,setsar=10/9" \
title.mp4

ffmpeg -f lavfi -i color=c=black:s=1280x800:d=1.0 -vf \
"drawtext=fontfile=./Korolev_bold.otf:fontsize=30: \
 fontcolor=white:x=(w-text_w)/2:y=(h-text_h)/2:text='twitch.tv/<username>' \
 ,setsar=10/9" \
end.mp4

```
ffmpeg -i title.mp4 -i asdf.mp4 -i credits.mp4 -filter_complex \
  '[0:0] [0:1] [0:2] [1:0] [1:1] [1:2] [2:0] [2:1] [2:2]
   concat=n=3:v=1:a=2 [v] [a1] [a2]' \
  -map '[v]' -map '[a1]' -map '[a2]' output.mp4
```

### GOOD COMMAND FOR CONCATING THE CLIPS
```
  ffmpeg -y -i title.mp4 -i ross.mp4 -i end.mp4 -filter_complex \
  '[0:0] [1:0] [2:0]
   concat=n=3:v=1 [v]' \
  -map '[v]' output.mp4
```

# trouble shooting encoding for upload

### Does work for concating
```
  ffmpeg -y -i title.mp4 -i asdf.mp4 -i end.mp4 -filter_complex \
  '[0:0] [1:0] [2:0]
   concat=n=3:v=1 [v]' \
  -map '[v]' \
  -c:v libx264 -preset fast -pix_fmt yuv420p -s 1280x800 -threads 0 -f flv -r 30 -fflags +genpts \ output.mp4
```

```
ffmpeg -y -t 30 -i "output.mp4" -t 30 -i "timelapse_audio.mp3" -map 0:v:0 -map 1:a:0 \
-c:v libx264 -preset fast -pix_fmt yuv420p -s 1280x800 -threads 0 -f flv -acodec aac -r 30 -fflags +genpts \
qwer.mp4
```
