defmodule Timelapser do
  use Application

  # See http://elixir-lang.org/docs/stable/elixir/Application.html
  # for more information on OTP Applications
  def start(_type, _args) do
    import Supervisor.Spec

    # Define workers and child supervisors to be supervised
    children = [
      # Start the Ecto repository
      supervisor(Timelapser.Repo, []),
      # Start the endpoint when the application starts
      supervisor(Timelapser.Endpoint, []),

      supervisor(Task.Supervisor, [[restart: :transient, max_restarts: 4, name: Timelapser.TaskSupervisor]]),
      # Start your own worker by calling: Timelapser.Worker.start_link(arg1, arg2, arg3)
      worker(Timelapser.TimelapseJobProducer, []),
    ]
    consumers = for id <- 1..(System.schedulers_online) do
      worker(Timelapser.TimelapseJobConsumer, [], id: id)
    end

    # See http://elixir-lang.org/docs/stable/elixir/Supervisor.html
    # for other strategies and supported options
    opts = [strategy: :one_for_one, name: Timelapser.Supervisor]
    Supervisor.start_link(children ++ consumers, opts)
  end

  # Tell Phoenix to update the endpoint configuration
  # whenever the application is updated.
  def config_change(changed, _new, removed) do
    Timelapser.Endpoint.config_change(changed, removed)
    :ok
  end
end
