defmodule Timelapser.Chunk do
  import FFprobe
  defstruct url: "", duration: 0

  def extract_chunks(filelist_url) do
    prefix = String.split(filelist_url, "/") |> Enum.drop(-1) |> Enum.join("/")
    HTTPoison.get!(filelist_url).body
    |> String.split("\n")
    |> list_to_chunks(prefix)
  end

  def list_to_chunks(list, prefix, chunks \\ [])
  def list_to_chunks(["#EXTINF:"<>duration_string | [path | rest]], prefix, chunks) do
    {duration, _comma} = Float.parse(duration_string)
    last_chunk = List.first(chunks) || %Timelapser.Chunk{}
    list_to_chunks(rest, prefix, [%Timelapser.Chunk{duration: duration + last_chunk.duration, url: prefix<>"/"<>path}] ++ chunks)
  end
  def list_to_chunks([_something_else | rest], prefix, chunks), do: list_to_chunks(rest, prefix, chunks)
  def list_to_chunks([], prefix, chunks), do: Enum.reverse(chunks)

end
