alias Experimental.GenStage
defmodule Timelapser.TimelapseJobConsumer do
  use GenStage
  alias Timelapser.Repo
  import Ecto.Query
  def start_link do
    GenStage.start_link(__MODULE__, :whatever)
  end

  def init(state) do
     {:consumer, state, subscribe_to: [{Timelapser.TimelapseJobProducer, min_demand: 0, max_demand: 1}]}
  end

  def handle_events([timelapse], _from, state) do
    task = Task.Supervisor.async_nolink(Timelapser.TaskSupervisor, fn-> Timelapser.Timelapse.build_timelapse(timelapse) end)
    monitor(task, timelapse)
    {:noreply, [], state}
  end

  # monitor checks the task to make sure its getting done, fails it if it isn't
  # and touches it if its still in process
  def monitor(task, timelapse) do
     timelapse = Timelapser.Repo.get!(Timelapser.Timelapse , timelapse.id)
     if timelapse.clip_url == nil do
       update_status(timelapse, "running")
       case Task.yield(task, 10_000)  do
          {:ok, result} -> update_status(timelapse, "success")
          {:exit, term} -> update_status(timelapse, "failure")
          nil           -> monitor(task, timelapse)
       end
     else
       # Should not happen
       Task.shutdown(task, :brutal_kill)
       update_status(timelapse, "success")
     end
  end

  defp update_status(timelapse, "failure") do
    send Timelapser.TimelapseJobProducer, :timelapse_enqueued
    Timelapser.Timelapse.update_timelapse(timelapse, [status: "failure", updated_at: Ecto.DateTime.utc])
  end
  defp update_status(timelapse, status), do: Timelapser.Timelapse.update_timelapse(timelapse, [status: status, updated_at: Ecto.DateTime.utc])
end
