defmodule Timelapser.TwitchApi do
  use HTTPoison.Base
  require IEx
  @oauth_token "4cbctq268yf5hkth2i32doek2sjvod"
  def process_url(url) do
    "https://api.twitch.tv/" <> url
  end

  def process_response_body(body) do
    body
    |> Poison.decode!
    |> Enum.into %{}
  end

  def get_vod("v/"<>vod_id), do: get_vod(vod_id)
  def get_vod("v"<>vod_id), do: get_vod(vod_id)
  def get_vod(vod_id) do
    Timelapser.TwitchApi.get!("kraken/videos/v#{vod_id}?oauth_token=#{@oauth_token}", %{"Client-ID" => "jzkbprff40iqj646a697cyrvl0zt2m6"}).body
  end

  def create_timelapse_upload(vod_title, channel, oauth_token \\ "4cbctq268yf5hkth2i32doek2sjvod") do
    Timelapser.TwitchApi.post!("kraken/videos?channel_id=#{channel}&oauth_token=#{oauth_token}&api_version=4&title=#{vod_title}&viewable=published", "", %{"Client-ID" => "jzkbprff40iqj646a697cyrvl0zt2m6"}).body
  end

  def get_playlist_url("v/"<>vod_id), do: get_playlist_url(vod_id)
  def get_playlist_url("v"<>vod_id), do: get_playlist_url(vod_id)
  def get_playlist_url(vod_id) do
    %{"token" => token, "sig" => sig } = Timelapser.TwitchApi.get!("api/vods/#{vod_id}/access_token?adblock=false&need_https=false&platform=web&player_type=site", %{"Client-ID" => "jzkbprff40iqj646a697cyrvl0zt2m6"}).body
    HTTPoison.get!("https://usher.ttvnw.net/vod/#{vod_id}.m3u8?nauth=#{URI.encode_www_form(token)}&nauthsig=#{sig}&allow_source=true&allow_spectre=true&player_backend=flash&p=2683732", %{"Client-ID" => "jzkbprff40iqj646a697cyrvl0zt2m6"}).body
    |> String.split("\n")
    |> Enum.find(fn line -> String.ends_with?(line, ".m3u8") end)
  end
end
