defmodule Timelapser.Vinyl do
  use HTTPoison.Base
  def process_url(path) do
    "http://vinyl-internal.production.us-west2.twitch.tv/" <> path
  end

  def process_response_body(body) do
    body
    |> Poison.decode!
    |> Enum.into %{}
  end

  def get_vod(vod_id) do
    get!("v1/vods?ids=#{vod_id}").body["vods"] |> List.first
  end

  def update_vod(vod_id, vod_params) do
    put!("v1/vods/#{vod_id}", Poison.encode!(vod_params)).body["vod"]
  end
end
