defmodule Timelapser.VodDownloader do
  use HTTPoison.Base

  def process_response_body(body) do
    body
    |> Poison.decode!
    |> Enum.into %{}
  end

  def process_url(path) do
    "http://downloader-production.us-west-2.elasticbeanstalk.com/" <> path
  end

  def download_url("v/"<>timelapse_vod_id), do: download_url(timelapse_vod_id)
  def download_url("v"<>timelapse_vod_id), do: download_url(timelapse_vod_id)
  def download_url(timelapse_vod_id) do
    get!("download/"<>timelapse_vod_id).body
  end


  def await_completion(timelapse_vod_id) do
    case download_url(timelapse_vod_id) do
      %{"status" => "complete", "download_url" => download_url} -> download_url
      %{"status" => "failed"} -> :error
      result ->
        :timer.sleep 10_000
        await_completion(timelapse_vod_id)
    end
  end
end
