defmodule Timelapser.VodUploader do
  use HTTPoison.Base
  alias Experimental.Flow
  @chunk_size round(10 * :math.pow(10, 6))

  def process_url(path) do
    "https://uploads.twitch.tv/" <> path
  end

  def upload("v/"<>timelapse_vod_id, upload_token, output_path), do: upload(timelapse_vod_id, upload_token, output_path)
  def upload("v"<>timelapse_vod_id, upload_token, output_path), do: upload(timelapse_vod_id, upload_token, output_path)
  def upload(timelapse_vod_id, upload_token, output_path) do
    File.stream!(output_path, [], @chunk_size)
    |> Enum.with_index
    |> Flow.from_enumerable
    |> Flow.partition
    |> Flow.each(fn {chunk, index} ->
      upload_chunk(timelapse_vod_id, upload_token, chunk, index + 1)
    end)
    |> Flow.run
    post!("upload/#{timelapse_vod_id}/complete?upload_token=#{upload_token}", "", timeout: :infinity).body
    await_completion(timelapse_vod_id)
  end

  defp upload_chunk(timelapse_vod_id, upload_token, chunk, part) do
    put!("upload/#{timelapse_vod_id}?part=#{part}&upload_token=#{upload_token}", chunk, timeout: :infinity)
  end

  defp await_completion("v"<>timelapse_vod_id), do: await_completion(timelapse_vod_id)
  defp await_completion(timelapse_vod_id) do
    case Timelapser.TwitchApi.get_vod(timelapse_vod_id) do
      %{"status" => "recorded"} -> :ok
      result ->
        :timer.sleep 10_000
        await_completion(timelapse_vod_id)
    end
  end
end
