defmodule Timelapser.Repo.Migrations.CreateBuildingBlock do
  use Ecto.Migration

  def change do
    create table(:building_blocks) do
      add :vod_id, :integer, null: false
      add :order, :integer, default: 0
      add :timelapse_id, references(:timelapses, on_delete: :nothing), null: false

      timestamps()
    end
    create index(:building_blocks, [:timelapse_id])
    create unique_index(:building_blocks, [:vod_id])
  end
end
