defmodule Timelapser.TimelapseController do
  use Timelapser.Web, :controller
  alias Timelapser.Timelapse
  def index(conn, _params) when _params == %{}  do
  timelapses = Repo.all(Timelapse)
    render(conn, "index.json", timelapses: timelapses)
  end

  # curl -H "Content-Type: application/json"  -d '{"timelapse": {"building_blocks": {"vod_id": 3}}}'   http://localhost:4000/api/timelapses
  def create(conn, %{
    "timelapse" => %{
      "building_blocks" => [%{
        "vod_id" => _vod_id
      }]
    } = timelapse_params
  }) do
    api_changeset = Timelapse.api_changeset(%Timelapse{}, timelapse_params)
    case Repo.insert(api_changeset) do
      {:ok, timelapse} ->
        send Timelapser.TimelapseJobProducer, :timelapse_enqueued
        conn
        |> put_status(:created)
        |> put_resp_header("location", timelapse_path(conn, :show, timelapse))
        |> render("show.json", timelapse: timelapse)
      {:error, api_changeset} ->
          conn
          |> put_status(:unprocessable_entity)
          |> render(Timelapser.ChangesetView, "error.json", api_changeset: api_changeset)
    end
  end

  def show(conn, %{"vod_id" => vod_id}) do
    timelapse = Timelapser.Timelapse.get_by_vod_id(vod_id)
    render(conn, "show.json", timelapse: timelapse)
  end
end
