defmodule Timelapser.BuildingBlock do
  use Timelapser.Web, :model

  schema "building_blocks" do
    field :vod_id, :integer
    field :order, :integer
    belongs_to :timelapse, Timelapser.Timelapse

    timestamps()
  end

  @doc """
  Builds a changeset based on the `struct` and `params`.
  """
  def changeset(struct, params \\ %{}) do
    struct
    |> cast(params, [:vod_id, :order])
    |> validate_required([:vod_id])
    |> unique_constraint(:vod_id) # Only for v1
  end
end
