defmodule Timelapser.TimelapseView do
  use Timelapser.Web, :view
  def render("index.json", %{timelapses: timelapses}) do
    %{timelapses: render_many(timelapses, Timelapser.TimelapseView, "timelapse.json")}
  end

  def render("show.json", %{timelapse: timelapse}) do
    %{timelapse: render_one(timelapse, Timelapser.TimelapseView, "timelapse.json")}
  end

  def render("timelapse.json", %{timelapse: timelapse}) do
    %{
      status: timelapse.status,
      clip_url: timelapse.clip_url,
      building_blocks: render_many(timelapse.building_blocks, Timelapser.BuildingBlockView, "building_block.json"),
      updated_at: timelapse.updated_at,
    }
  end
end
