# This file is responsible for configuring your application
# and its dependencies with the aid of the Mix.Config module.
#
# This configuration file is loaded before any dependency and
# is restricted to this project.
use Mix.Config

# General application configuration
config :tv,
  ecto_repos: [Tv.Repo]

# Configures the endpoint
config :tv, Tv.Endpoint,
  url: [host: "localhost"],
  secret_key_base: "CZG3s6/7wzns/pzuRSHuwQDta+w+G1XLiNf8PKCoHsoGxWtLyw4vO5d2ikMRmEtN",
  render_errors: [view: Tv.ErrorView, accepts: ~w(html json)],
  pubsub: [name: Tv.PubSub,
           adapter: Phoenix.PubSub.PG2]

# Configures Elixir's Logger
config :logger, :console,
  format: "$time $metadata[$level] $message\n",
  metadata: [:request_id]

# Import environment specific config. This must remain at the bottom
# of this file so it overrides the configuration defined above.
import_config "#{Mix.env}.exs"
