defmodule Tv.TvChannel do
  use Tv.Web, :channel

  def join("tv:"<>remote_id, payload, socket) do
    if authorized?(payload) do
      {:ok, socket}
    else
      {:error, %{reason: "unauthorized"}}
    end
  end

  # It is also common to receive messages from the client and
  # broadcast to everyone in the current topic (remote:lobby).
  def handle_in("connect_remote", payload, socket) do
    broadcast socket, "connect_remote", payload
    {:noreply, socket}
  end

  # It is also common to receive messages from the client and
  # broadcast to everyone in the current topic (remote:lobby).
  def handle_in("go_to_channel", %{"channel" => channel} = payload, socket) do
    broadcast socket, "go_to_channel", payload
    {:noreply, socket}
  end

  def handle_in("update_volume", %{"volume" => volume} = payload, socket) do
    broadcast socket, "update_volume", payload
    {:noreply, socket}
  end
  # Add authorization logic here as required.
  defp authorized?(_payload) do
    true
  end
end
