defmodule Tv.TvController do
  use Tv.Web, :controller
  def tv(conn, %{"id" => id}) do
    conn
    |> assign(:remote_url, conn.host <> remote_path(Tv.Endpoint, :remote, id))
    |> assign(:remote_url_qrcode, qr_code(conn.host <> remote_path(Tv.Endpoint, :remote, id)))
    |> assign(:id, id)
    |> render "tv.html"
  end
  def tv(conn, _params), do: redirect conn, to: "/tv/#{tv_id()}"

  def tv_id() do
    :crypto.strong_rand_bytes(10) |> Base.url_encode64 |> binary_part(0, 10)
  end

  def qr_code(url) do
    %{out: qrcode} = Porcelain.shell("qrcode #{url}")
    qrcode |> Base.encode64
  end
end
