defmodule Tv.Router do
  use Tv.Web, :router

  pipeline :browser do
    plug :accepts, ["html"]
    plug :fetch_session
    plug :fetch_flash
    plug :protect_from_forgery
    plug :put_secure_browser_headers
  end

  pipeline :api do
    plug :accepts, ["json"]
  end

  scope "/", Tv do
    pipe_through :browser # Use the default browser stack

    get "/tv/:id", TvController, :tv
    get "/tv", TvController, :tv
    get "/", TvController, :tv

    get "/remote/:id", RemoteController, :remote
    get "/remote", RemoteController, :remote
  end

  # Other scopes may use custom stacks.
  # scope "/api", Tv do
  #   pipe_through :api
  # end
end
