import React from "react"
import socket from "../socket"
import Slider from 'react-slick';
import $ from 'jquery';
export default class GameCarousel extends React.Component {
  constructor(props) {
    super(props)
    this.state = {
      games: [],
      streams: [],
      twitchChannel: null,
      mode: 'browsing'
    }
  }

  componentDidMount() {
    $.ajax({
      url: "https://api.twitch.tv/kraken/games/top?limit=100",
      dataType: 'json',
      beforeSend: (xhr) => {
         xhr.setRequestHeader('client-id', 'jzkbprff40iqj646a697cyrvl0zt2m6');
      }
    })
    .then((body) => {
      this.setState({games: body.top})
      this.selectGame(body.top[0])
    })
  }

  selectGame(game) {
    $.ajax({
      url: `https://api.twitch.tv/kraken/streams/?game=${game.game.name}`,
      dataType: 'json',
      beforeSend: (xhr) => {
         xhr.setRequestHeader('client-id', 'jzkbprff40iqj646a697cyrvl0zt2m6');
      }
    })
    .then((body) => {this.setState({streams: body.streams})})
  }

  renderGame(game) {
    return (
      <div key={game.game._id} onClick={this.selectGame.bind(this, game)}>
        <img src={game.game.box.medium}></img>
        <div>{game.game.localized_name}</div>
      </div>
    )
  }
  selectChannel(channel) {
    this.props.pushChannelUpdate(channel)
    this.setState({twitchChannel: channel})
    // this.setState({twitchChannel: channel, mode: 'chatting'})
  }

  browse() {
    this.setState({mode: 'browsing'})
  }

  chat() {
    this.setState({mode: 'chatting'})
  }

  renderStream(stream) {
    return (<div key={stream._id} onClick={this.selectChannel.bind(this, stream.channel.name)} style={{cursor: 'pointer'}}>
      <img src={stream.preview.small}></img>
      <div> {stream.channel.display_name}: {stream.channel.status} </div>
    </div>)
  }

  renderChat(channel) {
    if (!channel) {
      return <div></div>
    }
    return (<iframe frameBorder="0"
              scrolling="no"
              id="chat_embed"
              src={`https://m.twitch.tv/${channel}/rochat?theme=dark&fontsize=medium`}
              height="400"
              width="400">
      </iframe>)
  }

  render() {
    let settings = {
      dots: false,
      infinite: true,
      speed: 500,
      slidesToShow: 3,
      slidesToScroll: 3
    };
    if (this.state.games.length > 0 && this.state.mode === 'browsing') {
      return (
        <div>
          <div>
            <button onClick={this.chat.bind(this)}>Chat</button>
          </div>
          <Slider {...settings} style={{height: '10vh'}}>
            {this.state.games.map(this.renderGame.bind(this))}
          </Slider>
          <div  style={{'overflowY': 'auto', height: '40vh'}}>
            {this.state.streams.map(this.renderStream.bind(this))}
          </div>
        </div>
      )
    } else if (this.state.twitchChannel && this.state.mode === 'chatting'){
      return (
        <div style={{display: 'block'}}>
          <div>
            <button onClick={this.browse.bind(this)}>Browse</button>
          </div>
          {this.renderChat(this.state.twitchChannel)}
        </div>)
    } else {
      return <div><button onClick={this.browse.bind(this)}>Browse</button></div>
    }
  }
}
