import React from "react"
import socket from "../socket"
import GameCarousel from "./game_carousel"
import $ from "jquery"

export default class Remote extends React.Component {
  constructor(props) {
    super(props)
    this.state = {
      channel: null,
      twitchChannel: '',
      volume: 0.5
    }
  }

  componentDidMount() {
    this.state.channel = socket.channel(`tv:${this.props.id}`, {})
    this.state.channel.join()
      .receive("ok", function(resp) {
        this.state.channel.push("connect_remote", {})
      }.bind(this))
      .receive("error", resp => { console.log("Unable to join", resp) })

  }

  connectRemote(payload) {
    this.setState({connected: true})
  }

  componentWillUnmount() {
    this.state.channel.leave()
  }

  handleChannelEdit(e) {
    this.setState({twitchChannel: e.target.value});
  }

  handleChannelUpdate(event) {
    this.pushChannelUpdate(this.state.twitchChannel)
    event.preventDefault();
  }

  pushChannelUpdate(channel) {
    console.log(arguments)
    this.state.channel.push("go_to_channel", {channel})
  }

  handleVolumeUpdate(event) {
    this.state.channel.push("update_volume", {volume: event.target.value / 100})
  }

  render() {
    return (
      <div  style={{height: '10vh'}}>
        <form onSubmit={this.handleChannelUpdate.bind(this)}>
          <label>
            Channel: <input type="text" name="name"  value={this.state.twitchChannel} onChange={this.handleChannelEdit.bind(this)}/>
          </label>
          <input type="submit" value="Submit" />
        </form>
        <label>
          Volume: <input type="range" onChange={this.handleVolumeUpdate.bind(this)}></input>
        </label>
        <GameCarousel pushChannelUpdate={this.pushChannelUpdate.bind(this)}></GameCarousel>
      </div>
    )
  }
}
