import React from "react"
import socket from "../socket"

export default class Tv extends React.Component {
  constructor(props) {
    super(props)
    this.state = {
      connected: false,
      channel: null,
      volume: 0.5
    }
  }

  componentDidMount() {
    this.state.channel = socket.channel(`tv:${this.props.id}`, {})
    this.state.channel.join()
      .receive("ok", resp => { console.log("Joined successfully", resp) })
      .receive("error", resp => { console.log("Unable to join", resp) })
    this.state.channel.on("connect_remote", function(payload) {
      this.connectRemote(payload)
    }.bind(this))
    this.state.channel.on("go_to_channel", function(payload) {
      this.goToChannel(payload)
    }.bind(this))
    this.state.channel.on("update_volume", function(payload) {
      this.updateVolume(payload)
    }.bind(this))
  }

  connectRemote(payload) {
    this.setState({connected: true})
  }

  goToChannel(payload) {
    this.setState({twitchChannel: payload.channel})
    if (!this.state.player) {
      let options = {
        channel: payload.channel,
        height: 720,
        width: 1080,
      };
      this.setState({player: new Twitch.Player("twitchPlayer", options)})
      this.state.player.setVolume(0.5);
      this.state.player.setMuted(false);
    } else {
      this.state.player.setChannel(payload.channel);
      this.state.player.setMuted(false);
    }
  }

  updateVolume(payload) {
    this.setState({volume: payload.volume})
    this.state.player.setVolume(payload.volume);
  }


  componentWillUnmount() {
    this.state.channel.leave()
  }

  render() {
      return (
        <div style={{display: 'inline-block'}}>
          <div id="twitchPlayer" style={{display: 'inline'}}></div>
          <a href={"//" + this.props.remote_url}>
            <img alt="Embedded Image" src={'data:image/png;base64,' + this.props.qrCode}  style={{display: 'inline', 'verticalAlign': 'top'}}/>
            Open {this.props.remote_url} on your phone browser
          </a>
        </div>
      )
    }
  }
