defmodule TwirpEx.Application do
  # See http://elixir-lang.org/docs/stable/elixir/Application.html
  # for more information on OTP Applications
  @moduledoc false

  use Application

  alias Plug.Adapters.Cowboy

  def port do
    Application.get_env(:twirp_ex, :port, 4001)
  end

  def start_server do
    Application.get_env(:twirp_ex, :server, true)
  end

  def start(_type, _args) do
    import Supervisor.Spec, warn: false

    children = if start_server do
      [Cowboy.child_spec(:http, TwirpEx.Router, [], [port: port()])]
    else
      []
    end

    opts = [strategy: :one_for_one, name: TwirpEx.Supervisor]
    Supervisor.start_link(children, opts)
  end
end
