defmodule TwirpEx.Parser do
  @behaviour Plug.Parsers
  import Plug.Conn

  alias TwirpEx.Protobufs

  for {{:service,service}, rpcs} <- Protobufs.defs do
    for {:rpc, proc, arg, _resp, _, _,_} <- rpcs do
      namespace = Protobufs.namespace(service)
      proc = Atom.to_string(proc)
      arg = Protobufs.modularize(arg)

      def parse(%{path_info: ["twirp", unquote(namespace), unquote(proc)]} = conn, "application", "protobuf",_ , _) do
        {:ok, body, conn} = read_body(conn)
        decoded = unquote(arg).decode(body)
        {:ok, %{"_twirp" => decoded}, conn}
      end

      def parse(%{path_info: ["twirp", unquote(namespace), unquote(proc)]} = conn, _application, _json,_ , _) do
        {:ok, body, conn} = read_body(conn)
        params = %{"_twirp" => Poison.decode!(body, as: %unquote(arg){})}
        {:ok, params, conn}
      end
    end
  end

  def parse(conn, _type, _subtype, _params, _opts) do
    {:next, conn}
  end
end
