defmodule TwirpEx.Protobufs do
  use Protobuf, from: Application.get_env(:twirp_ex, :proto_path, Path.wildcard(Path.expand("rpc/*.proto"))),
    use_package_names: true,
    namespace: :"Elixir"

  for path <- Application.get_env(:twirp_ex, :proto_path, Path.wildcard(Path.expand("rpc/*.proto"))) do
    @external_resource path
  end

  def namespace(service) do
    service_namespace = to_string(service)
    |> String.split(".")
    |> Enum.drop(1)

    package_name = service_namespace
    |> Enum.reverse
    |> Enum.drop(1)
    |> Enum.reverse
    |> Enum.map(&String.downcase/1)
    |> Enum.join(".")

    service = service_namespace
    |> List.last

    "#{package_name}.#{service}"
  end

  def modularize(atom) when is_atom(atom), do: modularize(Atom.to_string(atom))
  def modularize("Elixir."<>_ = atom) do
    atom
    |> to_string
    |> String.split(".")
    |> Enum.map(&capitalize_first_letter/1)
    |> Enum.join(".")
    |> String.to_atom
  end
  def modularize(atom), do: modularize("Elixir."<>atom)

  defp capitalize_first_letter(string) do
    first_letter = string
    |> String.slice(0..0)
    |> String.capitalize()

    string_suffix = String.slice(string, 1..-1)
    "#{first_letter}#{string_suffix}"
  end
end
