defmodule TwirpEx.Status do
  @status_definitions %{
    canceled: 408,
    unknown: 500,
    invalid_argument: 400,
    deadline_exceeded: 408,
    not_found: 404,
    bad_route: 404,
    already_exists: 409,
    permission_denied: 403,
    unauthenticated: 401,
    resource_exhaused: 403,
    failed_precondition: 412,
    aborted: 409,
    out_of_range: 400,
    unimplemented: 501,
    internal: 500,
    unavailable: 503,
    dataloss: 500,
    ok: 200
  }

  def code_for_status(status), do: @status_definitions[status]
end
