defmodule Code.Justin.Tv.Example.Haberdasher.Haberdasher.MakeHat do
  alias Code.Justin.Tv.Example.Haberdasher.{Hat, Size}
  def run(%Size{inches: inches}) do
    %Hat{inches: inches, name: "bowler", color: "yellow"}
  end
end

defmodule Code.Justin.Tv.Example.Haberdasher.Haberdasher.MakeCachedHat do
  alias Code.Justin.Tv.Example.Haberdasher.{Hat, CacheSize}
  def run(%CacheSize{inches: inches, seconds: seconds}) do
    {:ok, %Hat{inches: inches, name: "bowler", color: "yellow"},
      headers: %{"cache-control" => "public, max-age=#{seconds}"}}
  end
end

defmodule Code.Justin.Tv.Example.Haberdasher.Haberdasher.MakeErrah do
  alias Code.Justin.Tv.Example.Haberdasher.Errah
  def run(%Errah{error_name: type}) do
    {:error, String.to_atom(type), msg: "message for #{type}", meta: %{ error_cause: "cause for #{type}"}}
  end
end
