defmodule TwirpExample.Mixfile do
  use Mix.Project

  def project do
    [app: :twirp_example,
     version: "0.1.0",
     elixir: "~> 1.4",
     build_embedded: Mix.env == :prod,
     start_permanent: Mix.env == :prod,
     deps: deps(),
     aliases: aliases(),
     default_task: "boot"]
  end

  # Configuration for the OTP application
  #
  # Type "mix help compile.app" for more information
  def application do
    # Specify extra applications you'll use from Erlang/Elixir
    [extra_applications: [:logger],
     mod: {TwirpExample.Application, []},
     applications: [:cowboy, :plug, :exprotobuf, :twirp_ex]]
  end

  # Dependencies can be Hex packages:
  #
  #   {:my_dep, "~> 0.3.0"}
  #
  # Or git/path repositories:
  #
  #   {:my_dep, git: "https://github.com/elixir-lang/my_dep.git", tag: "0.1.0"}
  #
  # Type "mix help deps" for more examples and options
  defp deps do
    [{:twirp_ex, git: "git@git-aws.internal.justin.tv:creative/twirp_ex.git"}]
  end

  defp aliases do
    [
      "boot": ["deps.compile twirp_ex"],
    ]
  end
end
