import argparse
import os
import sys
from pycaption import DFXPReader, SCCReader, CaptionConverter, SRTWriter

READERS = {
    '.dfxp': DFXPReader,
    '.scc': SCCReader
}


def srt_filename(filename):
    '''
    Rename provided filename to srt extension
    '''
    _, ext = os.path.splitext(filename)
    return '%s.%s' % (_, 'srt')


def convert(filename, output_file=False):
    '''
    Convert supported subtitle to SubRip format
    '''
    ext = os.path.splitext(filename)[1]
    Reader = READERS.get(ext, None)
    if Reader is not None:
        with open(filename, 'rb') as subfile:
            text = unicode(subfile.read(), 'utf-8')
            converter = CaptionConverter()
            converter.read(text, Reader())
            srt = converter.write(SRTWriter()).encode('utf-8').strip()
            if output_file is False:
                print(srt)
            else:
                with open(srt_filename(filename), 'w') as srtfile:
                    srtfile.write(srt)


if __name__ == '__main__':
    parser = argparse.ArgumentParser()
    parser.add_argument('path', help='path to supported subtitles')
    parser.add_argument('-o', '--output-path', help='output *.srt',
                        action='store_true')
    args = parser.parse_args()
    if os.path.isfile(args.path):
        convert(args.path, output_file=args.output_path)
    if os.path.isdir(args.path):
        subtitle_path = os.path.expanduser(args.path)
        for dirpath, dirnames, filenames in os.walk(subtitle_path):
            for filename in filenames:
                convert(os.path.join(dirpath, filename),
                        output_file=args.output_path)
