import argparse
import sys
import os
import csv


def file_from_sku(sku, ext, path='./'):
    '''
    Search provided path to get the on disk filename from the
    provided path dirname where SKU is found within the filename
    '''
    for dirpath, dirnames, filenames in os.walk(os.path.expanduser(path)):
        for filename in filenames:
            if sku in filename and ext in filename:
                return os.path.join(dirpath, filename)
    return None


def episode_filename(show, season, episode, ext, padding=3):
    '''
    Generate filename from episode details. Standard
    format will be {show_season_episode} where padding
    is used to zero pad the numbers of season and episode.
    '''
    return '_'.join([show.replace(' ', '_').lower(),
                     's' + season.zfill(padding),
                     'e' + episode.zfill(padding)]) + ext


if __name__ == '__main__':
    parser = argparse.ArgumentParser()
    parser.add_argument('csv', help='csv formatted episode list')
    parser.add_argument('inpath', help='input path containing files')
    parser.add_argument('outpath', help='path to put renamed files')
    args = parser.parse_args()
    with open(args.csv, 'rb') as csvfile:
        episode_list = csv.reader(csvfile, delimiter=',')
        row_count = 0
        next(episode_list)  # skip headers
        for episode in episode_list:
            # TODO use better header/id matching for this
            show = episode[0]
            season_num = episode[10]
            episode_num = episode[11]
            sku = episode[9]
            for file_ext in ['mpg', 'dfxp']:
                local_path = os.path.join('.', args.inpath)
                ugly_path = file_from_sku(sku, file_ext, path=local_path)
                if ugly_path is None:
                    continue
                _, ext = os.path.splitext(ugly_path)
                filename = episode_filename(show, season_num, episode_num, ext)
                os.rename(ugly_path, os.path.join('.', args.outpath, filename))
            row_count += 1
        print 'Completed renaming %d files' % row_count
